/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authtoken.api;

import com.floragunn.searchguard.authc.AuthInfoService;
import com.floragunn.searchguard.authtoken.AuthTokenService;
import com.floragunn.searchguard.authtoken.api.AbstractTransportAuthTokenAction;
import com.floragunn.searchguard.authtoken.api.SearchAuthTokensRequest;
import com.floragunn.searchguard.authtoken.api.SearchAuthTokensResponse;
import com.floragunn.searchguard.authz.PrivilegesEvaluator;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchguard.user.User;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportSearchAuthTokensAction
extends AbstractTransportAuthTokenAction<SearchAuthTokensRequest, SearchAuthTokensResponse> {
    private final AuthTokenService authTokenService;
    private final AuthInfoService authInfoService;
    private final PrivilegedConfigClient privilegedConfigClient;
    private final ThreadPool threadPool;

    @Inject
    public TransportSearchAuthTokensAction(AuthTokenService authTokenService, AuthInfoService authInfoService, TransportService transportService, ActionFilters actionFilters, Client client, PrivilegesEvaluator privilegesEvaluator, ThreadPool threadPool) {
        super("cluster:admin:searchguard:authtoken/_own/search", transportService, actionFilters, SearchAuthTokensRequest::new, privilegesEvaluator);
        this.authTokenService = authTokenService;
        this.authInfoService = authInfoService;
        this.privilegedConfigClient = PrivilegedConfigClient.adapt((Client)client);
        this.threadPool = threadPool;
    }

    protected final void doExecute(Task task, SearchAuthTokensRequest request, final ActionListener<SearchAuthTokensResponse> listener) {
        User user = this.authInfoService.getCurrentUser();
        SearchRequest searchRequest = new SearchRequest(new String[]{this.authTokenService.getIndexName()});
        if (request.getScroll() != null) {
            searchRequest.scroll(request.getScroll());
        }
        SearchSourceBuilder searchSourceBuilder = request.getSearchSourceBuilder();
        TransportAddress userRemoteAddress = (TransportAddress)this.threadPool.getThreadContext().getTransient("_sg_remote_address");
        if (searchSourceBuilder == null) {
            searchSourceBuilder = new SearchSourceBuilder();
            if (!this.isAllowedToAccessAll(user, userRemoteAddress)) {
                searchSourceBuilder.query((QueryBuilder)QueryBuilders.termQuery((String)"user_name", (String)user.getName()));
            } else {
                searchSourceBuilder.query((QueryBuilder)QueryBuilders.matchAllQuery());
            }
        } else if (!this.isAllowedToAccessAll(user, userRemoteAddress)) {
            QueryBuilder originalQuery = searchSourceBuilder.query();
            BoolQueryBuilder newQuery = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"user_name", (String)user.getName()));
            if (originalQuery != null) {
                newQuery.must(originalQuery);
            }
            searchSourceBuilder.query((QueryBuilder)newQuery);
        }
        if (request.getFrom() != -1) {
            searchSourceBuilder.from(request.getFrom());
        }
        if (request.getSize() != -1) {
            searchSourceBuilder.size(request.getSize());
        }
        searchRequest.source(searchSourceBuilder);
        this.privilegedConfigClient.execute((ActionType)SearchAction.INSTANCE, (ActionRequest)searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse response) {
                listener.onResponse((Object)new SearchAuthTokensResponse(response));
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }
}

